
CREATE FUNCTION dbo.mon_GetPenjualanPerCustomer(@Awal DATETIME, @Akhir DATETIME)
RETURNS TABLE
AS
RETURN
SELECT     dbo.m_customer.nama AS Customer, 
	dbo.m_kota.nama AS Kota, 
	TOTAL = SUM(dbo.GetHargaBersih(dbo.GetHargaBersih(dtl.harga_jual, dtl.diskon1, 
		dtl.diskon2, dtl.diskon3, dtl.diskon4, 0, 0), jual.diskon1, jual.diskon2, jual.diskon3, jual.diskon4, jual.pajak, 0) * dtl.qty)

FROM         dbo.t_penjualan jual INNER JOIN
	dbo.m_customer ON jual.kd_customer = dbo.m_customer.kd_customer INNER JOIN
	dbo.t_penjualan_detail dtl ON jual.no_transaksi = dtl.no_transaksi INNER JOIN
	dbo.m_kota ON dbo.m_customer.kd_kota = dbo.m_kota.kd_kota
WHERE dbo.GetFormatTanggal(tanggal) BETWEEN @Awal AND @Akhir
GROUP BY dbo.m_customer.nama, m_kota.nama

GO

CREATE FUNCTION  mon_GetPenjualanPerBarang(@Awal DATETIME, @Akhir DATETIME)
RETURNS TABLE
AS 
RETURN
	
	SELECT     dbo.m_kategori.nama AS Kategori, dtl.kd_barang AS [Kode Barang], dbo.m_barang.nama AS Barang, 
		SUM(dbo.GetHargaBersih(dbo.GetHargaBersih(dtl.harga_jual, dtl.diskon1, dtl.diskon2, dtl.diskon3, dtl.diskon4, 0, 0), jual.diskon1, jual.diskon2, 
			jual.diskon3, jual.diskon4, jual.pajak, 0) * dtl.qty) AS [Total Bersih], 
		SUM(dbo.GetMaxSatuan(dtl.kd_barang, dtl.kd_satuan, dtl.qty)) AS Kuantum, 
		dbo.GetMaxSatuanString(dtl.kd_barang, dtl.kd_satuan) AS Satuan, 
		SUM(dbo.GetKuantitasSatuanTerkecil(dtl.kd_barang,dtl.kd_satuan) * dtl.qty) as [Jumlah Terkecil]
	FROM         dbo.m_barang INNER JOIN
		dbo.t_penjualan jual INNER JOIN
		dbo.t_penjualan_detail dtl ON jual.no_transaksi = dtl.no_transaksi ON dbo.m_barang.kd_barang = dtl.kd_barang INNER JOIN
		dbo.m_kategori ON dbo.m_barang.kd_kategori = dbo.m_kategori.kd_kategori
	WHERE dbo.GetFormatTanggal(tanggal) BETWEEN @Awal AND @Akhir
	GROUP BY dtl.kd_barang, dbo.m_barang.nama, dbo.GetFormatTanggal(jual.tanggal), 
		dbo.GetMaxSatuanString(dtl.kd_barang, dtl.kd_satuan), dbo.m_kategori.nama


GO

INSERT INTO g_mon_menu_detail
SELECT 'Penjualan', 'Rekap Penjualan Per Customer', 'mon_GetPenjualanPerCustomer', 30, 'Roy', '*', 'F'

GO

INSERT INTO g_mon_menu_detail
SELECT 'Penjualan', 'Rekap Penjualan Per Barang', 'mon_GetPenjualanPerBarang', 31, 'Roy', '*', 'F'

GO

